//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright " 2007, Milan Volf"
#property link      ""

#property indicator_chart_window
#property indicator_buffers 2

#property indicator_color1 Blue
#property indicator_width1 1
#property indicator_color2 Red
#property indicator_width2 1

//---- input parameters
//---- buffers
double upArrow[];
double downArrow[];


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_ARROW,0,1);
   SetIndexArrow(0,233);
   SetIndexBuffer(0,upArrow);      
//----
   SetIndexStyle(1,DRAW_ARROW,0,1);
   SetIndexArrow(1,234);
   SetIndexBuffer(1,downArrow);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   ObjectsDeleteAll(0, OBJ_TEXT);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start(){
   int limit,i,up100current,down100current;  
   int counted_bars=IndicatorCounted();

   // Always prepare all of the information for the other indicators
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;

   //---- main loop
   for(i=limit;i>=0;i--){
      if(Close[i]<Close[i+1] && Close[i+1]<Close[i+2]
      && Close[i]-Low[i]>Close[i+1]-Low[i+1]
      && High[i]-Close[i]<High[i+1]-Close[i+1]) upArrow[i]=Low[i]-20*Point;
      else upArrow[i]=EMPTY_VALUE;
      
      if(Close[i]>Close[i+1] && Close[i+1]>Close[i+2]
      && High[i]-Close[i]>High[i+1]-Close[i+1]
      && Close[i]-Low[i]<Close[i+1]-Low[i+1]) downArrow[i]=High[i]+20*Point;
      else downArrow[i]=EMPTY_VALUE;
   }
   return(0);
}